/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.superplan;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cz.insophy.inplan.mrp.CustomerRequest;
import cz.insophy.inplan.mrp.SupplyRequest;
import cz.insophy.inplan.planning.algorithms.RebuildPlannerUtils;
import cz.insophy.inplan.remote.SuperplanCollator;
import cz.insophy.inplan.shop.Actiongram;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.store.MaterialRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.ProductionTreeAlgorithms;
import cz.insophy.inplan.superplan.ReleaseDateTruncator;
import cz.insophy.inplan.superplan.RequestedUpdater;
import cz.insophy.inplan.superplan.StartEndQtyUpdater;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.problems.Problem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestSynchronizer {
    private Superplan currentSuperplan;
    private ShopConfiguration shopConf;
    private List<GeneralizedOrderRequest> currentGors = Lists.newArrayList();
    private List<GeneralizedOrderRequest> loadedGors = Lists.newArrayList();
    private List<GeneralizedOrderRequest> addedGors = Lists.newArrayList();
    private List<GeneralizedOrderRequest> deletedGors = Lists.newArrayList();
    private List<GeneralizedOrderRequest> changedGors1 = Lists.newArrayList();
    private List<GeneralizedOrderRequest> changedGors2 = Lists.newArrayList();
    private Map<GeneralizedOrderRequest, GeneralizedOrderRequest> changedGorsMap = Maps.newHashMap();
    private List<List<SuperplanCollator.GorChangeComment>> changedGorsNotes = Lists.newArrayList();
    private Map<GeneralizedOrderRequest, List<SuperplanCollator.GorChangeComment>> changedGorsNotesMap = Maps.newHashMap();
    private List<MaterialRequest> currentMrs = Lists.newArrayList();
    private List<MaterialRequest> loadedMrs = Lists.newArrayList();
    private List<MaterialRequest> addedMrs = Lists.newArrayList();
    private List<MaterialRequest> deletedMrs = Lists.newArrayList();
    private List<MaterialRequest> changedMrs1 = Lists.newArrayList();
    private List<MaterialRequest> changedMrs2 = Lists.newArrayList();
    private Map<MaterialRequest, MaterialRequest> changedMrsMap = Maps.newHashMap();
    private List<List<SuperplanCollator.MrChangeComment>> changedMrsNotes = Lists.newArrayList();
    private Map<MaterialRequest, List<SuperplanCollator.MrChangeComment>> changedMrsNotesMap = Maps.newHashMap();
    private boolean checkMatprods;
    private boolean considerDescriptionChanges;
    private boolean considerReleaseDateChanges;
    private boolean considerDueDateChanges;
    private boolean considerQtyChanges;
    private boolean considerStateChanges;
    private boolean considerActiongramChanges;
    private boolean considerCustomPropertyChanges;
    private boolean considerPriorityChanges;
    private boolean considerProductChanges;
    private List<Problem> problems = Lists.newArrayList();
    private static final Logger log = LoggerFactory.getLogger(RequestSynchronizer.class);

    public RequestSynchronizer(Superplan currentSuperplan, Superplan loadedSuperplan, ShopConfiguration shopConf, boolean checkProducts) {
        this.currentSuperplan = currentSuperplan;
        this.shopConf = shopConf;
        this.checkMatprods = checkProducts;
        this.considerDescriptionChanges = true;
        this.considerReleaseDateChanges = false;
        this.considerDueDateChanges = true;
        this.considerQtyChanges = true;
        this.considerStateChanges = true;
        this.considerActiongramChanges = true;
        this.considerCustomPropertyChanges = true;
        this.considerPriorityChanges = true;
        this.considerProductChanges = true;
        this.currentGors = currentSuperplan.getGors();
        this.loadedGors = loadedSuperplan.getGors();
        this.currentMrs = currentSuperplan.getMaterialRequests();
        this.loadedMrs = loadedSuperplan.getMaterialRequests();
    }

    public RequestSynchronizer(Superplan currentSuperplan, Superplan loadedSuperplan) {
        this(currentSuperplan, loadedSuperplan, currentSuperplan.getShopConf());
    }

    public RequestSynchronizer(Superplan currentSuperplan, Superplan loadedSuperplan, ShopConfiguration shopConf) {
        this(currentSuperplan, loadedSuperplan, shopConf, true);
    }

    public boolean isCheckMatprods() {
        return this.checkMatprods;
    }

    public void setCheckMatprods(boolean checkMatprods) {
        this.checkMatprods = checkMatprods;
    }

    public boolean isConsiderDescriptionChanges() {
        return this.considerDescriptionChanges;
    }

    public void setConsiderDescriptionChanges(boolean considerDescriptionChanges) {
        this.considerDescriptionChanges = considerDescriptionChanges;
    }

    public boolean isConsiderReleaseDateChanges() {
        return this.considerReleaseDateChanges;
    }

    public void setConsiderReleaseDateChanges(boolean considerReleaseDateChanges) {
        this.considerReleaseDateChanges = considerReleaseDateChanges;
    }

    public boolean isConsiderDueDateChanges() {
        return this.considerDueDateChanges;
    }

    public void setConsiderDueDateChanges(boolean considerDueDateChanges) {
        this.considerDueDateChanges = considerDueDateChanges;
    }

    public boolean isConsiderQtyChanges() {
        return this.considerQtyChanges;
    }

    public void setConsiderQtyChanges(boolean considerQtyChanges) {
        this.considerQtyChanges = considerQtyChanges;
    }

    public boolean isConsiderStateChanges() {
        return this.considerStateChanges;
    }

    public void setConsiderStateChanges(boolean considerStateChanges) {
        this.considerStateChanges = considerStateChanges;
    }

    public boolean isConsiderActiongramChanges() {
        return this.considerActiongramChanges;
    }

    public void setConsiderActiongramChanges(boolean considerActiongramChanges) {
        this.considerActiongramChanges = considerActiongramChanges;
    }

    public boolean isConsiderCustomPropertyChanges() {
        return this.considerCustomPropertyChanges;
    }

    public void setConsiderCustomPropertyChanges(boolean considerCustomPropertyChanges) {
        this.considerCustomPropertyChanges = considerCustomPropertyChanges;
    }

    public boolean isConsiderPriorityChanges() {
        return this.considerPriorityChanges;
    }

    public void setConsiderPriorityChanges(boolean considerPriorityChanges) {
        this.considerPriorityChanges = considerPriorityChanges;
    }

    public boolean isConsiderProductChanges() {
        return this.considerProductChanges;
    }

    public void setConsiderProductChanges(boolean considerProductChanges) {
        this.considerProductChanges = considerProductChanges;
    }

    public void fetchChanges() {
        HashSet<SuperplanCollator.GorChangeComment> consideredChanges = Sets.newHashSet();
        if (this.considerDescriptionChanges) {
            consideredChanges.add(SuperplanCollator.GorChangeComment.DESCRIPTION);
        }
        if (this.considerReleaseDateChanges) {
            consideredChanges.add(SuperplanCollator.GorChangeComment.RELEASE_DATE);
        }
        if (this.considerDueDateChanges) {
            consideredChanges.add(SuperplanCollator.GorChangeComment.DUE_DATE);
        }
        if (this.considerQtyChanges) {
            consideredChanges.add(SuperplanCollator.GorChangeComment.QTY);
        }
        if (this.considerStateChanges) {
            consideredChanges.add(SuperplanCollator.GorChangeComment.STATE);
        }
        if (this.considerActiongramChanges) {
            consideredChanges.add(SuperplanCollator.GorChangeComment.ACTIONGRAM);
        }
        if (this.considerCustomPropertyChanges) {
            consideredChanges.add(SuperplanCollator.GorChangeComment.CUSTOM_PROPERTY);
        }
        if (this.considerPriorityChanges) {
            consideredChanges.add(SuperplanCollator.GorChangeComment.PRIORITY);
        }
        if (this.considerProductChanges) {
            consideredChanges.add(SuperplanCollator.GorChangeComment.PRODUCT);
        }
        this.problems.addAll(SuperplanCollator.compareGors(this.currentGors, this.loadedGors, this.deletedGors, this.addedGors, this.changedGors1, this.changedGors2, this.changedGorsNotes, consideredChanges));
        Iterator<GeneralizedOrderRequest> gorIt1 = this.changedGors1.iterator();
        Iterator<GeneralizedOrderRequest> gorIt2 = this.changedGors2.iterator();
        Iterator<List<SuperplanCollator.GorChangeComment>> gorNoteIt = this.changedGorsNotes.iterator();
        while (gorIt1.hasNext() && gorIt2.hasNext() && gorNoteIt.hasNext()) {
            GeneralizedOrderRequest gor1 = gorIt1.next();
            GeneralizedOrderRequest gor2 = gorIt2.next();
            List<SuperplanCollator.GorChangeComment> note = gorNoteIt.next();
            this.changedGorsMap.put(gor1, gor2);
            this.changedGorsNotesMap.put(gor1, note);
        }
        SuperplanCollator.compareMrs(this.currentMrs, this.loadedMrs, this.deletedMrs, this.addedMrs, this.changedMrs1, this.changedMrs2, this.changedMrsNotes);
        Iterator<MaterialRequest> mrIt1 = this.changedMrs1.iterator();
        Iterator<MaterialRequest> mrIt2 = this.changedMrs2.iterator();
        Iterator<List<SuperplanCollator.MrChangeComment>> mrNoteIt = this.changedMrsNotes.iterator();
        while (mrIt1.hasNext() && mrIt2.hasNext() && mrNoteIt.hasNext()) {
            MaterialRequest mr1 = mrIt1.next();
            MaterialRequest mr2 = mrIt2.next();
            List<SuperplanCollator.MrChangeComment> note = mrNoteIt.next();
            this.changedMrsMap.put(mr1, mr2);
            this.changedMrsNotesMap.put(mr1, note);
        }
    }

    public List<GeneralizedOrderRequest> getCurrentGors() {
        return this.currentGors;
    }

    public List<GeneralizedOrderRequest> getLoadedGors() {
        return this.loadedGors;
    }

    public List<GeneralizedOrderRequest> getAddedGors() {
        return this.addedGors;
    }

    public List<GeneralizedOrderRequest> getDeletedGors() {
        return this.deletedGors;
    }

    public Map<GeneralizedOrderRequest, GeneralizedOrderRequest> getChangedGors() {
        return this.changedGorsMap;
    }

    public List<GeneralizedOrderRequest> getChangedGorsCurrent() {
        return this.changedGors1;
    }

    public List<GeneralizedOrderRequest> getChangedGorsLoaded() {
        return this.changedGors2;
    }

    public List<List<SuperplanCollator.GorChangeComment>> getGorChangeComments() {
        return this.changedGorsNotes;
    }

    public Map<GeneralizedOrderRequest, List<SuperplanCollator.GorChangeComment>> getGorChangeCommentsMap() {
        return this.changedGorsNotesMap;
    }

    public Map<String, List<SuperplanCollator.GorChangeComment>> getChangeCommentsIdMap() {
        HashMap<String, List<SuperplanCollator.GorChangeComment>> gorCommentsMap = Maps.newHashMap();
        Iterator<GeneralizedOrderRequest> gorIt = this.changedGors1.iterator();
        Iterator<List<SuperplanCollator.GorChangeComment>> commentIt = this.changedGorsNotes.iterator();
        while (gorIt.hasNext() && commentIt.hasNext()) {
            gorCommentsMap.put(gorIt.next().getId(), commentIt.next());
        }
        return gorCommentsMap;
    }

    public List<GeneralizedOrderRequest> addGors(List<String> gorsToAdd) {
        LinkedList<String> gorsToAddCopy = Lists.newLinkedList(gorsToAdd);
        ArrayList<GeneralizedOrderRequest> reallyAddedGors = Lists.newArrayListWithExpectedSize(gorsToAdd.size());
        Iterator<GeneralizedOrderRequest> gorIt = this.loadedGors.iterator();
        while (gorIt.hasNext()) {
            GeneralizedOrderRequest gor = gorIt.next();
            if (!gorsToAddCopy.remove(gor.getId())) continue;
            gor.setPlan(null);
            this.currentSuperplan.addGor(gor);
            if (gor.getReleaseDate() < this.currentSuperplan.getFixationDate()) {
                ReleaseDateTruncator.updateFrom(gor, this.currentSuperplan.getFixationDate());
            }
            reallyAddedGors.add(gor);
            gorIt.remove();
        }
        return reallyAddedGors;
    }

    public List<GeneralizedOrderRequest> addAllGors() {
        ArrayList<GeneralizedOrderRequest> reallyAddedGors = Lists.newArrayListWithExpectedSize(this.loadedGors.size());
        Iterator<GeneralizedOrderRequest> gorIt = this.loadedGors.iterator();
        while (gorIt.hasNext()) {
            GeneralizedOrderRequest gor = gorIt.next();
            gor.setPlan(null);
            this.currentSuperplan.addGor(gor);
            if (gor.getReleaseDate() < this.currentSuperplan.getFixationDate()) {
                ReleaseDateTruncator.updateFrom(gor, this.currentSuperplan.getFixationDate());
            }
            reallyAddedGors.add(gor);
            gorIt.remove();
        }
        return reallyAddedGors;
    }

    public List<GeneralizedOrderRequest> addNewGors(List<String> gorsToAdd) {
        LinkedList<String> gorsToAddCopy = Lists.newLinkedList(gorsToAdd);
        ArrayList<GeneralizedOrderRequest> reallyAddedGors = Lists.newArrayListWithExpectedSize(gorsToAdd.size());
        Iterator<GeneralizedOrderRequest> gorIt = this.addedGors.iterator();
        while (gorIt.hasNext()) {
            GeneralizedOrderRequest gor = gorIt.next();
            if (!gorsToAddCopy.remove(gor.getId())) continue;
            gor.setPlan(null);
            this.currentSuperplan.addGor(gor);
            if (gor.getReleaseDate() < this.currentSuperplan.getFixationDate()) {
                ReleaseDateTruncator.updateFrom(gor, this.currentSuperplan.getFixationDate());
            }
            reallyAddedGors.add(gor);
            gorIt.remove();
        }
        return reallyAddedGors;
    }

    public List<GeneralizedOrderRequest> addAllNewGors() {
        ArrayList<GeneralizedOrderRequest> reallyAddedGors = Lists.newArrayListWithExpectedSize(this.addedGors.size());
        Iterator<GeneralizedOrderRequest> gorIt = this.addedGors.iterator();
        while (gorIt.hasNext()) {
            GeneralizedOrderRequest gor = gorIt.next();
            gor.setPlan(null);
            this.currentSuperplan.addGor(gor);
            if (gor.getReleaseDate() < this.currentSuperplan.getFixationDate()) {
                ReleaseDateTruncator.updateFrom(gor, this.currentSuperplan.getFixationDate());
            }
            reallyAddedGors.add(gor);
            gorIt.remove();
        }
        return reallyAddedGors;
    }

    public List<GeneralizedOrderRequest> deleteGors(List<String> gorsToDelete) {
        LinkedList<String> gorsToDeleteCopy = Lists.newLinkedList(gorsToDelete);
        ArrayList<GeneralizedOrderRequest> reallyDeletedGors = Lists.newArrayListWithExpectedSize(gorsToDelete.size());
        Iterator<GeneralizedOrderRequest> gorIt = this.currentGors.iterator();
        while (gorIt.hasNext()) {
            GeneralizedOrderRequest gor = gorIt.next();
            if (!gorsToDeleteCopy.remove(gor.getId())) continue;
            this.currentSuperplan.removeGor(gor);
            reallyDeletedGors.add(gor);
            gorIt.remove();
        }
        return reallyDeletedGors;
    }

    public List<GeneralizedOrderRequest> deleteAllGors() {
        ArrayList<GeneralizedOrderRequest> reallyDeletedGors = Lists.newArrayListWithExpectedSize(this.currentGors.size());
        Iterator<GeneralizedOrderRequest> gorIt = this.currentGors.iterator();
        while (gorIt.hasNext()) {
            GeneralizedOrderRequest gor = gorIt.next();
            this.currentSuperplan.removeGor(gor);
            reallyDeletedGors.add(gor);
            gorIt.remove();
        }
        return reallyDeletedGors;
    }

    public List<GeneralizedOrderRequest> deleteOldGors(List<String> gorsToDelete) {
        LinkedList<String> gorsToDeleteCopy = Lists.newLinkedList(gorsToDelete);
        ArrayList<GeneralizedOrderRequest> reallyDeletedGors = Lists.newArrayListWithExpectedSize(gorsToDelete.size());
        Iterator<GeneralizedOrderRequest> gorIt = this.deletedGors.iterator();
        while (gorIt.hasNext()) {
            GeneralizedOrderRequest gor = gorIt.next();
            if (!gorsToDeleteCopy.remove(gor.getId())) continue;
            this.currentSuperplan.removeGor(gor);
            reallyDeletedGors.add(gor);
            gorIt.remove();
        }
        return reallyDeletedGors;
    }

    public List<GeneralizedOrderRequest> deleteAllOldGors() {
        ArrayList<GeneralizedOrderRequest> reallyDeletedGors = Lists.newArrayListWithExpectedSize(this.deletedGors.size());
        Iterator<GeneralizedOrderRequest> gorIt = this.deletedGors.iterator();
        while (gorIt.hasNext()) {
            GeneralizedOrderRequest gor = gorIt.next();
            this.currentSuperplan.removeGor(gor);
            reallyDeletedGors.add(gor);
            gorIt.remove();
        }
        return reallyDeletedGors;
    }

    public List<GeneralizedOrderRequest> changeGors(List<String> gorsToChange) {
        LinkedList<String> gorsToChangeCopy = Lists.newLinkedList(gorsToChange);
        ArrayList<GeneralizedOrderRequest> reallyChangedGors = Lists.newArrayListWithExpectedSize(gorsToChange.size());
        Iterator<Map.Entry<GeneralizedOrderRequest, GeneralizedOrderRequest>> changedGorsIt = this.changedGorsMap.entrySet().iterator();
        while (changedGorsIt.hasNext()) {
            Actiongram loadedActiongram;
            Map.Entry<GeneralizedOrderRequest, GeneralizedOrderRequest> gors = changedGorsIt.next();
            GeneralizedOrderRequest currentGor = gors.getKey();
            GeneralizedOrderRequest loadedGor = gors.getValue();
            if (!gorsToChangeCopy.remove(currentGor.getId())) continue;
            List<SuperplanCollator.GorChangeComment> conflicts = this.changedGorsNotesMap.get(currentGor);
            if (conflicts.contains((Object)SuperplanCollator.GorChangeComment.PRODUCT)) {
                currentGor.setPlan(null);
                this.currentSuperplan.removeGor(currentGor);
                currentGor = new GeneralizedOrderRequest(currentGor.getId(), loadedGor.getProduct(), currentGor.getRequestedQty(), currentGor.getReleaseDate(), currentGor.getDueDate());
                this.currentSuperplan.addGor(currentGor);
            }
            if (conflicts.contains((Object)SuperplanCollator.GorChangeComment.ACTIONGRAM) && (loadedActiongram = loadedGor.getSelectedActiongram()) != null) {
                if (currentGor != null) {
                    ProductionTreeAlgorithms.removeRelatedActivities(currentGor);
                }
                RebuildPlannerUtils.fixAndRegister(this.currentSuperplan.getPlan());
                currentGor.setActiongramLocked(false);
                currentGor.cancelActiongram();
                currentGor.setActiongram(loadedActiongram);
                if (loadedGor.isActiongramLocked()) {
                    currentGor.setActiongramLocked(true);
                }
            }
            if (conflicts.contains((Object)SuperplanCollator.GorChangeComment.QTY)) {
                RequestedUpdater reqQtyUpdater = new RequestedUpdater(loadedGor.getRequestedQty());
                currentGor.accept(reqQtyUpdater, true);
                StartEndQtyUpdater.updateFrom(currentGor);
                ProductionTreeAlgorithms.cutOverplannedGars(currentGor);
            }
            if (conflicts.contains((Object)SuperplanCollator.GorChangeComment.DUE_DATE)) {
                currentGor.setDueDate(loadedGor.getDueDate());
            }
            if (conflicts.contains((Object)SuperplanCollator.GorChangeComment.RELEASE_DATE)) {
                currentGor.setReleaseDate(Math.max(loadedGor.getReleaseDate(), this.currentSuperplan.getFixationDate()));
            }
            if (conflicts.contains((Object)SuperplanCollator.GorChangeComment.STATE)) {
                currentGor.setState(loadedGor.getState());
            }
            if (conflicts.contains((Object)SuperplanCollator.GorChangeComment.DESCRIPTION)) {
                currentGor.setDescription(loadedGor.getDescription());
            }
            if (conflicts.contains((Object)SuperplanCollator.GorChangeComment.PRIORITY)) {
                currentGor.setPriority(loadedGor.getPriority());
            }
            if (conflicts.contains((Object)SuperplanCollator.GorChangeComment.CUSTOM_PROPERTY)) {
                currentGor.resetProperties(loadedGor.getProperties());
            }
            reallyChangedGors.add(currentGor);
            changedGorsIt.remove();
        }
        return reallyChangedGors;
    }

    public List<GeneralizedOrderRequest> changeAllGors() {
        ArrayList<GeneralizedOrderRequest> reallyChangedGors = Lists.newArrayListWithExpectedSize(this.changedGorsMap.size());
        Iterator<Map.Entry<GeneralizedOrderRequest, GeneralizedOrderRequest>> changedGorsIt = this.changedGorsMap.entrySet().iterator();
        while (changedGorsIt.hasNext()) {
            Actiongram loadedActiongram;
            Map.Entry<GeneralizedOrderRequest, GeneralizedOrderRequest> gors = changedGorsIt.next();
            GeneralizedOrderRequest currentGor = gors.getKey();
            GeneralizedOrderRequest loadedGor = gors.getValue();
            List<SuperplanCollator.GorChangeComment> conflicts = this.changedGorsNotesMap.get(currentGor);
            if (conflicts.contains((Object)SuperplanCollator.GorChangeComment.PRODUCT)) {
                currentGor.setPlan(null);
                this.currentSuperplan.removeGor(currentGor);
                currentGor = new GeneralizedOrderRequest(currentGor.getId(), loadedGor.getProduct(), currentGor.getRequestedQty(), currentGor.getReleaseDate(), currentGor.getDueDate());
                this.currentSuperplan.addGor(currentGor);
            }
            if (conflicts.contains((Object)SuperplanCollator.GorChangeComment.ACTIONGRAM) && (loadedActiongram = loadedGor.getSelectedActiongram()) != null) {
                ProductionTreeAlgorithms.removeRelatedActivities(currentGor);
                RebuildPlannerUtils.fixAndRegister(this.currentSuperplan.getPlan());
                currentGor.setActiongramLocked(false);
                currentGor.cancelActiongram();
                currentGor.setActiongram(loadedActiongram);
                if (loadedGor.isActiongramLocked()) {
                    currentGor.setActiongramLocked(true);
                }
            }
            if (conflicts.contains((Object)SuperplanCollator.GorChangeComment.QTY)) {
                RequestedUpdater reqQtyUpdater = new RequestedUpdater(loadedGor.getRequestedQty());
                currentGor.accept(reqQtyUpdater, true);
                StartEndQtyUpdater.updateFrom(currentGor);
            }
            if (conflicts.contains((Object)SuperplanCollator.GorChangeComment.DUE_DATE)) {
                currentGor.setDueDate(loadedGor.getDueDate());
            }
            if (conflicts.contains((Object)SuperplanCollator.GorChangeComment.RELEASE_DATE)) {
                currentGor.setReleaseDate(Math.max(loadedGor.getReleaseDate(), this.currentSuperplan.getFixationDate()));
            }
            if (conflicts.contains((Object)SuperplanCollator.GorChangeComment.STATE)) {
                currentGor.setState(loadedGor.getState());
            }
            if (conflicts.contains((Object)SuperplanCollator.GorChangeComment.DESCRIPTION)) {
                currentGor.setDescription(loadedGor.getDescription());
            }
            if (conflicts.contains((Object)SuperplanCollator.GorChangeComment.PRIORITY)) {
                currentGor.setPriority(loadedGor.getPriority());
            }
            if (conflicts.contains((Object)SuperplanCollator.GorChangeComment.CUSTOM_PROPERTY)) {
                currentGor.resetProperties(loadedGor.getProperties());
            }
            reallyChangedGors.add(currentGor);
            changedGorsIt.remove();
        }
        return reallyChangedGors;
    }

    public List<GeneralizedOrderRequest> processAllGors() {
        LinkedList<GeneralizedOrderRequest> affectedGors = Lists.newLinkedList(this.addAllNewGors());
        affectedGors.addAll(this.deleteAllOldGors());
        affectedGors.addAll(this.changeAllGors());
        return affectedGors;
    }

    public List<GeneralizedOrderRequest> replaceAllGors() {
        LinkedList<GeneralizedOrderRequest> affectedGors = Lists.newLinkedList(this.deleteAllGors());
        affectedGors.addAll(this.addAllGors());
        return affectedGors;
    }

    public List<MaterialRequest> getCurrentMrs() {
        return this.currentMrs;
    }

    public List<MaterialRequest> getLoadedMrs() {
        return this.loadedMrs;
    }

    public List<MaterialRequest> getAddedMrs() {
        return this.addedMrs;
    }

    public List<MaterialRequest> getDeletedMrs() {
        return this.deletedMrs;
    }

    public Map<MaterialRequest, MaterialRequest> getChangedMrs() {
        return this.changedMrsMap;
    }

    public List<MaterialRequest> getChangedMrsCurrent() {
        return this.changedMrs1;
    }

    public List<MaterialRequest> getChangedMrsLoaded() {
        return this.changedMrs2;
    }

    public List<List<SuperplanCollator.MrChangeComment>> getMrChangeComments() {
        return this.changedMrsNotes;
    }

    public Map<MaterialRequest, List<SuperplanCollator.MrChangeComment>> getMrChangeCommentsMap() {
        return this.changedMrsNotesMap;
    }

    public Map<String, List<SuperplanCollator.MrChangeComment>> getMrChangeCommentsIdMap() {
        HashMap<String, List<SuperplanCollator.MrChangeComment>> mrCommentsMap = Maps.newHashMap();
        Iterator<MaterialRequest> mrIt = this.changedMrs1.iterator();
        Iterator<List<SuperplanCollator.MrChangeComment>> commentIt = this.changedMrsNotes.iterator();
        while (mrIt.hasNext() && commentIt.hasNext()) {
            mrCommentsMap.put(mrIt.next().getId(), commentIt.next());
        }
        return mrCommentsMap;
    }

    public List<MaterialRequest> addMrs(List<String> mrsToAdd) {
        LinkedList<String> mrsToAddCopy = Lists.newLinkedList(mrsToAdd);
        ArrayList<MaterialRequest> reallyAddedMrs = Lists.newArrayListWithExpectedSize(mrsToAdd.size());
        Iterator<MaterialRequest> mrIt = this.loadedMrs.iterator();
        while (mrIt.hasNext()) {
            MaterialRequest mr = mrIt.next();
            if (!mrsToAddCopy.remove(mr.getId())) continue;
            if (this.checkMatprods && this.shopConf.getMatprod(mr.getMaterial().getName()) == null) {
                log.debug("Material request " + mr.getId() + " has an unknown matprod " + mr.getMaterial().getName());
                this.problems.add(Problem.createProblem2("02100", mr, mr.getMaterial()));
                continue;
            }
            mr.setPlan(null);
            if (mr instanceof SupplyRequest) {
                this.currentSuperplan.addSupplyRequest((SupplyRequest)mr);
            } else if (mr instanceof CustomerRequest) {
                this.currentSuperplan.addCustomerRequest((CustomerRequest)mr);
            }
            reallyAddedMrs.add(mr);
            mrIt.remove();
        }
        return reallyAddedMrs;
    }

    public List<MaterialRequest> addAllMrs() {
        ArrayList<MaterialRequest> reallyAddedMrs = Lists.newArrayListWithCapacity(this.loadedMrs.size());
        Iterator<MaterialRequest> mrIt = this.loadedMrs.iterator();
        while (mrIt.hasNext()) {
            MaterialRequest mr = mrIt.next();
            if (this.checkMatprods && this.shopConf.getMatprod(mr.getMaterial().getName()) == null) {
                log.debug("Material request " + mr.getId() + " has an unknown matprod " + mr.getMaterial().getName());
                this.problems.add(Problem.createProblem2("02100", mr, mr.getMaterial()));
                continue;
            }
            mr.setPlan(null);
            if (mr instanceof SupplyRequest) {
                this.currentSuperplan.addSupplyRequest((SupplyRequest)mr);
            } else if (mr instanceof CustomerRequest) {
                this.currentSuperplan.addCustomerRequest((CustomerRequest)mr);
            }
            reallyAddedMrs.add(mr);
            mrIt.remove();
        }
        return reallyAddedMrs;
    }

    public List<MaterialRequest> addNewMrs(List<String> mrsToAdd) {
        LinkedList<String> mrsToAddCopy = Lists.newLinkedList(mrsToAdd);
        ArrayList<MaterialRequest> reallyAddedMrs = Lists.newArrayListWithExpectedSize(mrsToAdd.size());
        Iterator<MaterialRequest> mrIt = this.addedMrs.iterator();
        while (mrIt.hasNext()) {
            MaterialRequest mr = mrIt.next();
            if (!mrsToAddCopy.remove(mr.getId())) continue;
            if (this.checkMatprods && this.shopConf.getMatprod(mr.getMaterial().getName()) == null) {
                log.debug("Material request " + mr.getId() + " has an unknown matprod " + mr.getMaterial());
                this.problems.add(Problem.createProblem2("02100", mr, mr.getMaterial()));
                continue;
            }
            mr.setPlan(null);
            if (mr instanceof SupplyRequest) {
                this.currentSuperplan.addSupplyRequest((SupplyRequest)mr);
            } else if (mr instanceof CustomerRequest) {
                this.currentSuperplan.addCustomerRequest((CustomerRequest)mr);
            }
            reallyAddedMrs.add(mr);
            mrIt.remove();
        }
        return reallyAddedMrs;
    }

    public List<MaterialRequest> addAllNewMrs() {
        ArrayList<MaterialRequest> reallyAddedMrs = Lists.newArrayListWithCapacity(this.addedMrs.size());
        Iterator<MaterialRequest> mrIt = this.addedMrs.iterator();
        while (mrIt.hasNext()) {
            MaterialRequest mr = mrIt.next();
            if (this.checkMatprods && this.shopConf.getMatprod(mr.getMaterial().getName()) == null) {
                log.debug("Material request " + mr.getId() + " has an unknown matprod " + mr.getMaterial());
                this.problems.add(Problem.createProblem2("02100", mr, mr.getMaterial()));
                continue;
            }
            mr.setPlan(null);
            if (mr instanceof SupplyRequest) {
                this.currentSuperplan.addSupplyRequest((SupplyRequest)mr);
            } else if (mr instanceof CustomerRequest) {
                this.currentSuperplan.addCustomerRequest((CustomerRequest)mr);
            }
            reallyAddedMrs.add(mr);
            mrIt.remove();
        }
        return reallyAddedMrs;
    }

    public List<MaterialRequest> deleteMrs(List<String> mrsToDelete) {
        LinkedList<String> mrsToDeleteCopy = Lists.newLinkedList(mrsToDelete);
        ArrayList<MaterialRequest> reallyDeletedMrs = Lists.newArrayListWithExpectedSize(mrsToDelete.size());
        Iterator<MaterialRequest> mrIt = this.currentMrs.iterator();
        while (mrIt.hasNext()) {
            MaterialRequest mr = mrIt.next();
            if (!mrsToDeleteCopy.remove(mr.getId())) continue;
            if (mr instanceof SupplyRequest) {
                this.currentSuperplan.removeSupplyRequest((SupplyRequest)mr);
            } else if (mr instanceof CustomerRequest) {
                this.currentSuperplan.removeCustomerRequest((CustomerRequest)mr);
            }
            reallyDeletedMrs.add(mr);
            mrIt.remove();
        }
        return reallyDeletedMrs;
    }

    public List<MaterialRequest> deleteAllMrs() {
        ArrayList<MaterialRequest> reallyDeletedMrs = Lists.newArrayListWithCapacity(this.currentMrs.size());
        Iterator<MaterialRequest> mrIt = this.currentMrs.iterator();
        while (mrIt.hasNext()) {
            MaterialRequest mr = mrIt.next();
            if (mr instanceof SupplyRequest) {
                this.currentSuperplan.removeSupplyRequest((SupplyRequest)mr);
            } else if (mr instanceof CustomerRequest) {
                this.currentSuperplan.removeCustomerRequest((CustomerRequest)mr);
            }
            reallyDeletedMrs.add(mr);
            mrIt.remove();
        }
        return reallyDeletedMrs;
    }

    public List<MaterialRequest> deleteOldMrs(List<String> mrsToDelete) {
        LinkedList<String> mrsToDeleteCopy = Lists.newLinkedList(mrsToDelete);
        ArrayList<MaterialRequest> reallyDeletedMrs = Lists.newArrayListWithExpectedSize(mrsToDelete.size());
        Iterator<MaterialRequest> mrIt = this.deletedMrs.iterator();
        while (mrIt.hasNext()) {
            MaterialRequest mr = mrIt.next();
            if (!mrsToDeleteCopy.remove(mr.getId())) continue;
            if (mr instanceof SupplyRequest) {
                this.currentSuperplan.removeSupplyRequest((SupplyRequest)mr);
            } else if (mr instanceof CustomerRequest) {
                this.currentSuperplan.removeCustomerRequest((CustomerRequest)mr);
            }
            reallyDeletedMrs.add(mr);
            mrIt.remove();
        }
        return reallyDeletedMrs;
    }

    public List<MaterialRequest> deleteAllOldMrs() {
        ArrayList<MaterialRequest> reallyDeletedMrs = Lists.newArrayListWithCapacity(this.deletedMrs.size());
        Iterator<MaterialRequest> mrIt = this.deletedMrs.iterator();
        while (mrIt.hasNext()) {
            MaterialRequest mr = mrIt.next();
            if (mr instanceof SupplyRequest) {
                this.currentSuperplan.removeSupplyRequest((SupplyRequest)mr);
            } else if (mr instanceof CustomerRequest) {
                this.currentSuperplan.removeCustomerRequest((CustomerRequest)mr);
            }
            reallyDeletedMrs.add(mr);
            mrIt.remove();
        }
        return reallyDeletedMrs;
    }

    public List<MaterialRequest> changeMrs(List<String> mrsToChange) {
        LinkedList<String> mrsToChangeCopy = Lists.newLinkedList(mrsToChange);
        ArrayList<MaterialRequest> reallyChangedMrs = Lists.newArrayListWithCapacity(mrsToChange.size());
        Iterator<Map.Entry<MaterialRequest, MaterialRequest>> changedMrsIt = this.changedMrsMap.entrySet().iterator();
        while (changedMrsIt.hasNext()) {
            Map.Entry<MaterialRequest, MaterialRequest> mrs = changedMrsIt.next();
            MaterialRequest currentMr = mrs.getKey();
            MaterialRequest loadedMr = mrs.getValue();
            if (!mrsToChangeCopy.remove(currentMr.getId())) continue;
            if (this.checkMatprods && this.shopConf.getMatprod(loadedMr.getMaterial().getName()) == null) {
                this.problems.add(Problem.createProblem2("02100", loadedMr, loadedMr.getMaterial()));
                continue;
            }
            if (currentMr instanceof SupplyRequest) {
                this.currentSuperplan.removeSupplyRequest((SupplyRequest)currentMr);
            } else if (currentMr instanceof CustomerRequest) {
                this.currentSuperplan.removeCustomerRequest((CustomerRequest)currentMr);
            }
            if (loadedMr instanceof SupplyRequest) {
                this.currentSuperplan.removeSupplyRequest((SupplyRequest)loadedMr);
            } else if (loadedMr instanceof CustomerRequest) {
                this.currentSuperplan.removeCustomerRequest((CustomerRequest)loadedMr);
            }
            reallyChangedMrs.add(currentMr);
            changedMrsIt.remove();
        }
        return reallyChangedMrs;
    }

    public List<MaterialRequest> changeAllMrs() {
        ArrayList<MaterialRequest> reallyChangedMrs = Lists.newArrayListWithCapacity(this.changedMrsMap.size());
        Iterator<Map.Entry<MaterialRequest, MaterialRequest>> changedMrsIt = this.changedMrsMap.entrySet().iterator();
        while (changedMrsIt.hasNext()) {
            Map.Entry<MaterialRequest, MaterialRequest> mrs = changedMrsIt.next();
            MaterialRequest currentMr = mrs.getKey();
            MaterialRequest loadedMr = mrs.getValue();
            if (this.checkMatprods && this.shopConf.getMatprod(loadedMr.getMaterial().getName()) == null) {
                this.problems.add(Problem.createProblem2("02100", loadedMr, loadedMr.getMaterial()));
                continue;
            }
            if (currentMr instanceof SupplyRequest) {
                this.currentSuperplan.removeSupplyRequest((SupplyRequest)currentMr);
            } else if (currentMr instanceof CustomerRequest) {
                this.currentSuperplan.removeCustomerRequest((CustomerRequest)currentMr);
            }
            if (loadedMr instanceof SupplyRequest) {
                this.currentSuperplan.removeSupplyRequest((SupplyRequest)loadedMr);
            } else if (loadedMr instanceof CustomerRequest) {
                this.currentSuperplan.removeCustomerRequest((CustomerRequest)loadedMr);
            }
            reallyChangedMrs.add(currentMr);
            changedMrsIt.remove();
        }
        return reallyChangedMrs;
    }

    public List<MaterialRequest> processAllMrs() {
        LinkedList<MaterialRequest> affectedMrs = Lists.newLinkedList(this.addAllNewMrs());
        affectedMrs.addAll(this.deleteAllOldMrs());
        affectedMrs.addAll(this.changeAllMrs());
        return affectedMrs;
    }

    public List<MaterialRequest> replaceAllMrs() {
        LinkedList<MaterialRequest> affectedMrs = Lists.newLinkedList(this.deleteAllMrs());
        affectedMrs.addAll(this.addAllMrs());
        return affectedMrs;
    }

    public void synchronizeAll() {
        this.fetchChanges();
        this.processAllGors();
        this.processAllMrs();
    }

    public void replaceAll() {
        this.replaceAllGors();
        this.replaceAllMrs();
    }

    public List<Problem> getProblems() {
        return Collections.unmodifiableList(this.problems);
    }
}

